function show_s1q1_results(s,m)
   final_simul_time  = s.latest_system_time;
   total_nb_requests = m.number_accepted_services + m.number_rejected_services;
   accepted_requests = m.number_accepted_services;
   fraction_accepted = 100*accepted_requests / total_nb_requests;
   rejected_requests = m.number_rejected_services;
   fraction_rejected = 100* rejected_requests / total_nb_requests;
   mean_service_time = m.server_busy_time / accepted_requests;
   mean_arrival_time = final_simul_time / total_nb_requests;
     total_busy_time = m.server_busy_time;
  fraction_busy_time = 100* total_busy_time / final_simul_time;
  mean_waiting_time  = m.queue_wait_time / accepted_requests;
   
   printf("\n")
   printf("\n---Results of Simulation:\n"); 
   printf("   total_nb_requests = %i\n", total_nb_requests);
   printf("    total_simul_time = %i\n", final_simul_time);
   printf("   total_nb_accepted = %i (%4.1f of total)\n", accepted_requests, fraction_accepted);
   printf("   total_nb_rejected = %i (%4.1f of total)\n", rejected_requests, fraction_rejected);
   printf("    server_busy_time = %i (%4.1f of total)\n", total_busy_time, fraction_busy_time);
   printf("   mean_service_time = %4.2f\n", mean_service_time);
   printf("   mean_arrival_time = %4.2f\n", mean_arrival_time);
   printf("   mean_waiting_time = %4.2f\n", mean_waiting_time);
   printf("\n")
end