function M = read_matrix(fname) 
% the function reads a matrix V from a file that has an initial info line
   fid = fopen(fname,"r");
   line = fgetl(fid);
   pos_1 = findstr("are the ", line);
   pos_2 = findstr(" x ", line);
   pos_3 = findstr(" elements ", line);
   m = str2num(line(pos_1+9:pos_2-1));
   n = str2num(line(pos_2+3:pos_3-1));
   M = zeros(m,n);
   for i = 1:n
      line = fgetl(fid);
      M(i,:) = str2num(line);
   end
   fclose(fid);
end