function M = mat_mult(A,B)
% the function retuns the poduct of matrices A and B
% if the matrices are incompatible returns an empty arrayfun
   m = rows(A);
   p = columns(A);
   n = columns(B);
   if rows(B) != p
      M = [];
   else
      M = zeros(m,n);
      for i = 1:m
         for j = 1:n
            for k = 1:p
               M(i,j) = M(i,j) + A(i,k)*B(k,j);
            end
         end
      end
   end
end