function x = cubic(a,b,c,d);
% x is one of the roots of the cubic equation ax^3 +bx^2+cx + d=0
%  For example in equation  x^3-15x-4=0 the parameters are
%  a= 1, b= 0, c = -15, d = -4
% cf: https://math.vanderbilt.edu/schectex/courses/cubic/
   p = -b/(3*a)
   q = p^3 + (b*c-3*a*d)/(6*a^2)
   r = c/(3*a)
   s = sqrt(q^2 +(r-p^2)^3)
   x1 = (q + s)^(1/3)
   x2 = (q - s)^(1/3)
   x = x1 + x2 + p
end
  